using UnityEngine;
using UnityEngine.UI;
using UnityEngine.SceneManagement;

/*
 * Handler of Start Menu UI and Manager of Settings and Statistics
 */
public class StatsManager : MonoBehaviour
{
    public static StatsManager instance;
    bool visualisation = true;

    public Image setupScreen;
    public Image advScreen;
    public bool largeCommunity = false;
    bool homeScreen;
    public bool running;

    public Image runScreen;
    public NonSimulationScript runPrefab;
    public Text runNumber;
    public Text runTitle;

    public Button visualisationButton;
    public Button consoleButton;
    public Dropdown roundTypeDropdown;

    public int numVoters;
    public int numRounds;
    public int networkSize;
    public int roundType;
    public float alphaValue;

    public float speed = 1;
    public float compGain = 8.0f;
    public float compImp = 1.0f;
    public float prefAttach = 1.0f;
    public bool analysis = false;
    public bool setChance = false;

    public Slider numVoterSlider;
    public Text numVoterText;
    public Slider numRoundsSlider;
    public Text numRoundsText;
    public Slider networkSlider;
    public Text numNetworkText;

    public Button autoButton;
    public Button analysisButton;

    public Button button1x;
    public Button button2x;
    public Button button100x;

    public Button compAvgLow;
    public Button compAvgMed;
    public Button compAvgHigh;

    public Button compImpNone;
    public Button compImpLow;
    public Button compImpMed;
    public Button compImpHigh;

    public Button prefAttachNone;
    public Button prefAttachLow;
    public Button prefAttachMed;
    public Button prefAttachHigh;

    public Slider alphaSlider;
    public Text alphaText;

    public int round;
    public int correct;
    public int incorrect;
    public float numGurusTotal;
    public float highestPowerTotal;
    public double avgCompetenceTotal;

    // Set to not be destroyed to it can be accessed in simulation and statistics scenes
    private void Awake()
    {
        if (instance == null)
        {
            instance = this;
        }

        else if (instance != this)
        {
            Destroy(instance.gameObject);
            instance = this;
        }

        homeScreen = true;
        running = false;
        DontDestroyOnLoad(gameObject);
    }

    // Updates values for sliders when they are changed, and updates round number for non-visualised simulations
    private void FixedUpdate()
    {
        if (homeScreen)
        {
            numVoterText.text = numVoterSlider.value.ToString();
            numRoundsText.text = numRoundsSlider.value.ToString();
            networkSlider.maxValue = numVoterSlider.value;
            numNetworkText.text = networkSlider.value.ToString();

            alphaText.text = (alphaSlider.value / 100).ToString();
        }
        if (running)
        {
            runNumber.text = instance.round.ToString();
        }
    }

    // Start Button starts simulation
    public void StartSimulation()
    {
        round = 0;
        correct = 0;
        incorrect = 0;
        highestPowerTotal = 0;

        homeScreen = false;
        numVoters = (int)numVoterSlider.value;
        numRounds = (int)numRoundsSlider.value;
        networkSize = (int)networkSlider.value;
        alphaValue = alphaSlider.value / 100;

        roundType = roundTypeDropdown.value;

        // Visualised simulation, new scene loaded
        if (visualisation)
        {
            if(numVoters >= 60) { largeCommunity = true;  }

            SceneManager.LoadScene("SimulationScene");
        }
        // Non-visualised simualtion, run in this scene
        else
        {
            setupScreen.GetComponent<RectTransform>().anchoredPosition = new Vector2(1146.8f, 0);
            runScreen.GetComponent<RectTransform>().anchoredPosition = new Vector2(146.8f, -2.4f);
            runTitle.text = "Simulating " + numRounds + " Votes";
            running = true;

            NonSimulationScript run = Instantiate(runPrefab, new Vector3(0, 0, 0), Quaternion.identity);
        }
    }

    // Cancel button from non-visualised simulation ends the simulation and takes user back to menu screen
    public void Cancel()
    {
        SceneManager.LoadScene("MenuScene");
    }

    /*
     * The following methods control the settings of the simulations, explained by their names:
     */

    public void VisualisationOn()
    {
        visualisation = true;
        visualisationButton.GetComponent<Image>().color = new Color(0.6f, 1, 0.9f, 1);
        consoleButton.GetComponent<Image>().color = new Color(1, 1, 1, 1);
        numVoterSlider.maxValue = 100;
        numRoundsSlider.maxValue = 100;
    }

    public void VisualisationOff()
    {
        visualisation = false;
        visualisationButton.GetComponent<Image>().color = new Color(1, 1, 1, 1);
        consoleButton.GetComponent<Image>().color = new Color(0.6f, 1, 0.9f, 1);
        numVoterSlider.maxValue = 1000;
        numRoundsSlider.maxValue = 10000;
    }

    public void SetSpeed1x()
    {
        button1x.GetComponent<Image>().color = new Color(0.6f, 1, 0.9f, 1);
        button2x.GetComponent<Image>().color = new Color(1, 1, 1, 1);
        button100x.GetComponent<Image>().color = new Color(1, 1, 1, 1);

        speed = 1;
    }

    public void SetSpeed2x()
    {
        button1x.GetComponent<Image>().color = new Color(1, 1, 1, 1);
        button2x.GetComponent<Image>().color = new Color(0.6f, 1, 0.9f, 1);
        button100x.GetComponent<Image>().color = new Color(1, 1, 1, 1);

        speed = 2;
    }

    public void SetSpeed100x()
    {
        button1x.GetComponent<Image>().color = new Color(1, 1, 1, 1);
        button2x.GetComponent<Image>().color = new Color(1, 1, 1, 1);
        button100x.GetComponent<Image>().color = new Color(0.6f, 1, 0.9f, 1);

        speed = 100;
    }

    public void SetCompAvgLow()
    {
        compAvgLow.GetComponent<Image>().color = new Color(0.6f, 1, 0.9f, 1);
        compAvgMed.GetComponent<Image>().color = new Color(1, 1, 1, 1);
        compAvgHigh.GetComponent<Image>().color = new Color(1, 1, 1, 1);

        compGain = 4.0f;
    }

    public void SetCompAvgMed()
    {
        compAvgLow.GetComponent<Image>().color = new Color(1, 1, 1, 1);
        compAvgMed.GetComponent<Image>().color = new Color(0.6f, 1, 0.9f, 1);
        compAvgHigh.GetComponent<Image>().color = new Color(1, 1, 1, 1);

        compGain = 8.0f;
    }

    public void SetCompAvgHigh()
    {
        compAvgLow.GetComponent<Image>().color = new Color(1, 1, 1, 1);
        compAvgMed.GetComponent<Image>().color = new Color(1, 1, 1, 1);
        compAvgHigh.GetComponent<Image>().color = new Color(0.6f, 1, 0.9f, 1);

        compGain = 12.0f;
    }

    public void SetCompImpNone()
    {
        compImpNone.GetComponent<Image>().color = new Color(0.6f, 1, 0.9f, 1);
        compImpLow.GetComponent<Image>().color = new Color(1, 1, 1, 1);
        compImpMed.GetComponent<Image>().color = new Color(1, 1, 1, 1);
        compImpHigh.GetComponent<Image>().color = new Color(1, 1, 1, 1);

        compImp = 0.0f;
    }

    public void SetCompImpLow()
    {
        compImpNone.GetComponent<Image>().color = new Color(1, 1, 1, 1);
        compImpLow.GetComponent<Image>().color = new Color(0.6f, 1, 0.9f, 1);
        compImpMed.GetComponent<Image>().color = new Color(1, 1, 1, 1);
        compImpHigh.GetComponent<Image>().color = new Color(1, 1, 1, 1);

        compImp = 0.5f;
    }

    public void SetCompImpMed()
    {
        compImpNone.GetComponent<Image>().color = new Color(1, 1, 1, 1);
        compImpLow.GetComponent<Image>().color = new Color(1, 1, 1, 1);
        compImpMed.GetComponent<Image>().color = new Color(0.6f, 1, 0.9f, 1);
        compImpHigh.GetComponent<Image>().color = new Color(1, 1, 1, 1);

        compImp = 1.0f;
    }

    public void SetCompImpHigh()
    {
        compImpNone.GetComponent<Image>().color = new Color(1, 1, 1, 1);
        compImpLow.GetComponent<Image>().color = new Color(1, 1, 1, 1);
        compImpMed.GetComponent<Image>().color = new Color(1, 1, 1, 1);
        compImpHigh.GetComponent<Image>().color = new Color(0.6f, 1, 0.9f, 1);

        compImp = 2.0f;
    }

    public void SetPrefAttachNone()
    {
        prefAttachNone.GetComponent<Image>().color = new Color(0.6f, 1, 0.9f, 1);
        prefAttachLow.GetComponent<Image>().color = new Color(1, 1, 1, 1);
        prefAttachMed.GetComponent<Image>().color = new Color(1, 1, 1, 1);
        prefAttachHigh.GetComponent<Image>().color = new Color(1, 1, 1, 1);

        prefAttach = 0.0f;
    }

    public void SetPrefAttachLow()
    {
        prefAttachNone.GetComponent<Image>().color = new Color(1, 1, 1, 1);
        prefAttachLow.GetComponent<Image>().color = new Color(0.6f, 1, 0.9f, 1);
        prefAttachMed.GetComponent<Image>().color = new Color(1, 1, 1, 1);
        prefAttachHigh.GetComponent<Image>().color = new Color(1, 1, 1, 1);

        prefAttach = 0.5f;
    }

    public void SetPrefAttachMed()
    {
        prefAttachNone.GetComponent<Image>().color = new Color(1, 1, 1, 1);
        prefAttachLow.GetComponent<Image>().color = new Color(1, 1, 1, 1);
        prefAttachMed.GetComponent<Image>().color = new Color(0.6f, 1, 0.9f, 1);
        prefAttachHigh.GetComponent<Image>().color = new Color(1, 1, 1, 1);

        prefAttach = 1.0f;
    }

    public void SetPrefAttachHigh()
    {
        prefAttachNone.GetComponent<Image>().color = new Color(1, 1, 1, 1);
        prefAttachLow.GetComponent<Image>().color = new Color(1, 1, 1, 1);
        prefAttachMed.GetComponent<Image>().color = new Color(1, 1, 1, 1);
        prefAttachHigh.GetComponent<Image>().color = new Color(0.6f, 1, 0.9f, 1);

        prefAttach = 2.0f;
    }

    public void SetAuto()
    {
        analysis = false;
        autoButton.GetComponent<Image>().color = new Color(0.6f, 1, 0.9f, 1);
        analysisButton.GetComponent<Image>().color = new Color(1, 1, 1, 1);
    }

    public void SetAnalysis()
    {
        analysis = true;
        autoButton.GetComponent<Image>().color = new Color(1, 1, 1, 1);
        analysisButton.GetComponent<Image>().color = new Color(0.6f, 1, 0.9f, 1);
    }

    public void OpenAdvSettings()
    {
        setupScreen.GetComponent<RectTransform>().anchoredPosition = new Vector2(1146.8f, 0);
        advScreen.GetComponent<RectTransform>().anchoredPosition = new Vector2(146.8f, -2.4f);
    }

    public void CloseAdvSettings()
    {
        advScreen.GetComponent<RectTransform>().anchoredPosition = new Vector2(1146.8f, 0);
        setupScreen.GetComponent<RectTransform>().anchoredPosition = new Vector2(146.8f, -2.4f);
    }

    // Closes the program
    public void ExitSimulation()
    {
        Application.Quit();
    }
}